VERSION 5.00
Begin VB.Form frmEZScan_NI488 
   Caption         =   "Form1"
   ClientHeight    =   3600
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5250
   LinkTopic       =   "Form1"
   ScaleHeight     =   3600
   ScaleWidth      =   5250
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtReadings 
      Height          =   3135
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "frmEZScan_NI488.frx":0000
      Top             =   240
      Width           =   2175
   End
   Begin VB.CommandButton cmdScan 
      Caption         =   "Start Scan"
      Height          =   855
      Left            =   2640
      TabIndex        =   0
      Top             =   240
      Width           =   2295
   End
End
Attribute VB_Name = "frmEZScan_NI488"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'' """""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
''    Copyright  2002 Agilent Technologies Inc. All rights
''    reserved.
''
'' You have a royalty-free right to use, modify, reproduce and distribute
'' the Sample Application Files (and/or any modified version) in any way
'' you find useful, provided that you agree that Agilent has no
'' warranty,  obligations or liability for any Sample Application Files.
''
'' Agilent Technologies provides programming examples for illustration only,
'' This sample program assumes that you are familiar with the programming
'' language being demonstrated and the tools used to create and debug
'' procedures. Agilent support engineers can help explain the
'' functionality of Agilent software components and associated
'' commands, but they will not modify these samples to provide added
'' functionality or construct procedures to meet your specific needs.
'' """"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
'
' This code implements a simple scan with the 34970A using the National Instruments
' NI-488.2 IO
'
Const DAQ_ADDRESS = "9"
Dim DAQ As Integer


Private Sub cmdScan_Click()
' initialize io object set the functions and then scan
    Dim readings() As Double
    Dim cmd As String
    Dim strTemp As String
    Dim strReadings() As String
    Dim strres As String * 10000
    Dim readingCount As Integer
    Dim i As Long


    initialize_IO


    ' Stop any ongoing scan
    cmd = "Abort"
    ilwrt DAQ, cmd, Len(cmd)

    ' reset instrument
    cmd = "*RST"
    ilwrt DAQ, cmd, Len(cmd)

    ' configure for DC and Resistance
    cmd = "Conf:volt:DC Auto,(@101,102);:Volt:DC:NPLC 0.02,(@101,102)"
    ilwrt DAQ, cmd, Len(cmd)
    cmd = "Conf:Res Auto,(@106:108);:Res:NPLC 0.02,(@106:108)"
    ilwrt DAQ, cmd, Len(cmd)
    cmd = "Route:Scan (@101,102,106:108)"
    ilwrt DAQ, cmd, Len(cmd)

    ' determine the size of the scan
    cmd = "Rout:Scan:Size?"
    ilwrt DAQ, cmd, Len(cmd)
    ' return reading as a string
    ilrd DAQ, strres, Len(strres)
    readingCount = Left$(strres, ibcntl - 1)

    ' initialize and wait for the scan to complete
    cmd = "INIT"
    ilwrt DAQ, cmd, Len(cmd)
    cmd = "*OPC?"
    ilwrt DAQ, cmd, Len(cmd)
    ilrd DAQ, strres, Len(strres)

    cmd = "Fetch?"
    ilwrt DAQ, cmd, Len(cmd)
    ilrd DAQ, strres, Len(strres)
    strTemp = Left$(strres, ibcntl - 1)
    
    ' put the string data into an array
    strReadings = Split(strTemp, ",")

    ReDim readings(UBound(strReadings))

    With txtReadings
        .Text = ""
        .SelText = Now & vbCrLf
        For i = 0 To UBound(readings)
            .SelText = strReadings(i) & vbCrLf
            ' create an array of doubles (not used here)
            readings(i) = Val(strReadings(i))
        Next i
    End With

End Sub

' initializes the GPIB port
Public Sub initialize_IO()
    Dim msg As String
    
    On Error GoTo InitializeError
    
    DAQ = ildev(0, DAQ_ADDRESS, 0, _
                 T10s, 1, 1)
    If (ibsta And EERR) Then
        msg = "Unable to connect to 34970A" & vbCrLf & "ibsta = &H" & _
        vbCrLf & Hex(ibsta) & "iberr = " & iberr
        MsgBox msg, vbCritical, "Error"
        GoTo InitializeError
    End If
    
    ilclr DAQ
    If (ibsta And EERR) Then
        Call GPIBCleanup("Unable to clear 34970A", DAQ)
    End If
    
  
    
    Exit Sub
    
InitializeError:
    Debug.Print "Error in initialize_IO; "; Err.Description


End Sub

Private Sub GPIBCleanup(ByVal msg As String, ByVal device As Integer)
    
    ' After each GPIB call, the application checks whether the call
    ' succeeded. If an NI-488.2 call fails, the GPIB driver sets the
    ' corresponding bit in the global status variable. If the call
    ' failed, this procedure prints an error message, takes the device
    ' offline and exits.

    ErrorMnemonic = Array("EDVR", "ECIC", "ENOL", "EADR", "EARG", _
                          "ESAC", "EABO", "ENEB", "EDMA", "", _
                          "EOIP", "ECAP", "EFSO", "", "EBUS", _
                          "ESTB", "ESRQ", "", "", "", "ETAB")

    msg = msg & vbCrLf & "ibsta = &H" & Hex(ibsta) & vbCrLf _
              & "iberr = " & iberr & " <" & ErrorMnemonic(iberr) & ">"
    MsgBox msg, vbCritical, "Error"
    ilonl device, 0
    
End Sub




